IF OBJECT_ID('VW_CLI_PENDENTES_ANONIM_LGPD', 'V') IS NOT NULL
    DROP VIEW VW_CLI_PENDENTES_ANONIM_LGPD
GO



CREATE VIEW VW_CLI_PENDENTES_ANONIM_LGPD AS
select c.CD_CLI, c.Rz_cli, FORMAT(max(i.DT_HR_ACEITE_LGPD),'dd/MM/yyyy HH:mm:ss', 'pt-br') as dt_recusa, COUNT(r.CD_CLI) as DEBITOS,
    SUM(CHEQUE) AS CHEQUES, SUM(TITULO) AS TITULOS, SUM(PEDIDO) AS PEDIDOS, SUM(CONVENIO) AS CONVENIOS, SUM(NFE) AS NFE
from  RC_CLI c 
INNER JOIN PDV_ACEITE_LGPD_RC_CLI i on (i.CD_CLI = c.CD_CLI)
LEFT JOIN
	(SELECT 
		RC_DEB.CD_CLI, RC_CLI.CD_EMP, 
		('DEBITO') AS DESCRICAO, 0 AS CHEQUE, 1 AS TITULO, 0 AS PEDIDO, 0 AS CONVENIO, 0 AS CREDIARIO, 0 AS NFE
    FROM RC_DEB RC_DEB
			JOIN RC_CLI ON RC_DEB.CD_EMP = RC_CLI.CD_EMP
				AND RC_DEB.CD_CLI = RC_CLI.CD_CLI 
	WHERE RC_DEB.CD_EMP  = 1 
	   AND RC_DEB.STS_DP  IN (0,2,5)
	   AND RC_CLI.PESSOA  = 0 
	   
	union
	
		SELECT  
		RC_CLI.CD_CLI, PDV_VD_CHQS.CD_EMP,
		('CHEQUE') AS DESCRICAO, 1 as CHEQUE, 0 AS TITULO, 0 AS PEDIDO, 0 AS CONVENIO, 0 AS CREDIARIO, 0 AS NFE
	FROM PDV_VD
		JOIN PDV_VD_CHQS ON PDV_VD.CD_EMP    = PDV_VD_CHQS.CD_EMP   
			AND PDV_VD.CD_FILIAL = PDV_VD_CHQS.CD_FILIAL
			AND PDV_VD.CD_VD     = PDV_VD_CHQS.CD_VD  
		JOIN PDV_VD_CHQS_CHQ_LANC ON PDV_VD_CHQS.CD_EMP    = PDV_VD_CHQS_CHQ_LANC.CD_EMP   						
 			AND PDV_VD_CHQS.CD_FILIAL = PDV_VD_CHQS_CHQ_LANC.CD_FILIAL
			AND PDV_VD_CHQS.CD_VD     = PDV_VD_CHQS_CHQ_LANC.CD_VD  
			AND PDV_VD_CHQS.NR_ORD    = PDV_VD_CHQS_CHQ_LANC.NR_ORD  
		JOIN CHQ_LANC_CPL ON CHQ_LANC_CPL.CD_EMP = PDV_VD_CHQS_CHQ_LANC.CD_EMP
			AND CHQ_LANC_CPL.CD_CHQ = PDV_VD_CHQS_CHQ_LANC.CD_CHQ
		JOIN RC_CLI ON RC_CLI.CD_EMP = PDV_VD.CD_EMP
			AND RC_CLI.CD_CLI = PDV_VD.CD_CLI 
    WHERE PDV_VD.CD_EMP = 1  
		AND RC_CLI.PESSOA =  0
		AND CHQ_LANC_CPL.STS_CHQ IN (0,1,2,5,6,7,9)   


    union
	
-- Relação de pedidos de venda 
	SELECT EST_PED_VD.CD_CLI, EST_PED_VD.CD_EMP, 
		('PEDIDO') AS DESCRICAO, 0 AS CHEQUE, 0 AS TITULO, 1 AS PEDIDO, 0 AS CONVENIO, 0 AS CREDIARIO, 0 AS NFE
	FROM EST_PED_VD
			JOIN RC_CLI ON EST_PED_VD.CD_EMP = RC_CLI.CD_EMP 
				AND EST_PED_VD.CD_CLI = RC_CLI.CD_CLI 
	WHERE EST_PED_VD.CD_EMP = 1 
	  AND EST_PED_VD.STS_PED =0
	  AND RC_CLI.PESSOA = 0
	  
   UNION 

-- Relação de titulos de Convênios
	SELECT RC_CLI.CD_CLI, RC_CLI.CD_EMP, 
		('CONVENIOS') AS DESCRICAO, 0 AS CHEQUE, 0 AS TITULO, 0 AS PEDIDO, 1 AS CONVENIO, 0 AS CREDIARIO, 0 AS NFE
	FROM RC_CLI_CONV_RC_CLI 
			JOIN RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CONV_RC_CLI.CD_EMP
				AND RC_CLI.CD_CLI = RC_CLI_CONV_RC_CLI.CD_CLI
	  WHERE RC_CLI.CD_EMP = 1 
	    AND RC_CLI_CONV_RC_CLI.VLR_DEB > 0
	    AND RC_CLI.PESSOA =  0
		
   UNION		
-- Relação de titulos de Crediário
	   SELECT RC_CLI.CD_CLI, RC_CLI.CD_EMP, 
		('CREDIARIO') AS DESCRICAO, 0 AS CHEQUE, 0 AS TITULO, 0 AS PEDIDO, 0 AS CONVENIO, 1 AS CREDIARIO, 0 AS NFE
	FROM RC_CLI_CREDIARIO 
			JOIN RC_CLI ON RC_CLI.CD_EMP = RC_CLI_CREDIARIO.CD_EMP
				AND RC_CLI.CD_CLI = RC_CLI_CREDIARIO.CD_CLI
	WHERE RC_CLI.CD_EMP = 1 
		AND RC_CLI_CREDIARIO.VLR_DEB_CRED > 0
		AND RC_CLI.PESSOA =  0
 
   UNION
-- Relação de titulos originados por emissão de NF-e
	SELECT RC_CLI.CD_CLI, RC_CLI.CD_EMP, 
		('NFE') AS DESCRICAO, 0 AS CHEQUE, 0 AS TITULO, 0 AS PEDIDO, 0 AS CONVENIO, 0 AS CREDIARIO, 1 AS NFE
	FROM EST_NF_SAI 
		JOIN RC_CLI ON EST_NF_SAI.CD_CLI = RC_CLI.CD_CLI
	WHERE EST_NF_SAI.STS_NF= 0 
	    AND RC_CLI.PESSOA = 0 
		AND NOT EXISTS (SELECT 
							CD_CTR_ARQ 
						FROM 
							EST_NF_SAI_ARQ_DANFE 
						WHERE 
							EST_NF_SAI_ARQ_DANFE.CD_EMP    = EST_NF_SAI.CD_EMP 
							AND EST_NF_SAI_ARQ_DANFE.CD_FILIAL = EST_NF_SAI.CD_FILIAL 
							AND EST_NF_SAI_ARQ_DANFE.CD_NF     = EST_NF_SAI.CD_NF)	
	
    ) r 
	on (r.CD_CLI = c.CD_CLI) and (r.CD_EMP = c.CD_EMP)
	
where (c.ACEITE_LGPD = 3 and i.ACEITE_LGPD = 2)
group by c.CD_CLI, c.Rz_cli;














